VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4320
   ClientLeft      =   2130
   ClientTop       =   2340
   ClientWidth     =   7980
   LinkTopic       =   "Form1"
   ScaleHeight     =   4320
   ScaleWidth      =   7980
   Begin VB.CheckBox Check1 
      Caption         =   "Relay 4 is Input"
      Height          =   255
      Index           =   3
      Left            =   5400
      TabIndex        =   21
      Top             =   1920
      Width           =   1695
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Relay 3 is Input"
      Height          =   255
      Index           =   2
      Left            =   5400
      TabIndex        =   20
      Top             =   1560
      Width           =   1695
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Relay 2 is Input"
      Height          =   255
      Index           =   1
      Left            =   5400
      TabIndex        =   19
      Top             =   1200
      Width           =   1695
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Relay 1 is Input"
      Height          =   255
      Index           =   0
      Left            =   5400
      TabIndex        =   18
      Top             =   840
      Width           =   1695
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   3360
      TabIndex        =   11
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   960
      Width           =   735
   End
   Begin VB.Frame Frame3 
      Caption         =   "Output Relay Control"
      Enabled         =   0   'False
      Height          =   855
      Left            =   1080
      TabIndex        =   2
      Top             =   1800
      Width           =   2175
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   7
         Left            =   120
         TabIndex        =   10
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   6
         Left            =   360
         TabIndex        =   9
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   5
         Left            =   600
         TabIndex        =   8
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   4
         Left            =   840
         TabIndex        =   7
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   3
         Left            =   1080
         TabIndex        =   6
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   2
         Left            =   1320
         TabIndex        =   5
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   1
         Left            =   1560
         TabIndex        =   4
         Top             =   360
         Width           =   255
      End
      Begin VB.CheckBox chkPortB 
         Caption         =   "Check2"
         Height          =   195
         Index           =   0
         Left            =   1800
         TabIndex        =   3
         Top             =   360
         Width           =   255
      End
      Begin VB.Label Label9 
         Caption         =   "K1"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   5.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   120
         TabIndex        =   17
         Top             =   600
         Width           =   255
      End
      Begin VB.Label Label8 
         Caption         =   "K4"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   5.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   1080
         TabIndex        =   16
         Top             =   600
         Width           =   255
      End
      Begin VB.Label Label5 
         Caption         =   "K8"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   5.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   135
         Left            =   1800
         TabIndex        =   15
         Top             =   600
         Width           =   255
      End
   End
   Begin VB.Timer Timer1 
      Left            =   360
      Top             =   1800
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize KPCI board"
      Height          =   375
      Left            =   1080
      TabIndex        =   0
      Top             =   960
      Width           =   2055
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   360
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   360
      Top             =   1200
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   "Values from Input Relays (if present)"
      Height          =   495
      Left            =   3600
      TabIndex        =   23
      Top             =   1680
      Width           =   1575
   End
   Begin VB.Label lblDIValue 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   3720
      TabIndex        =   22
      Top             =   2280
      Width           =   1455
   End
   Begin VB.Label Label7 
      Caption         =   "KPCI-PIOxx Digital Channel 2"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3720
      TabIndex        =   14
      Top             =   2880
      Width           =   2295
   End
   Begin VB.Label Label6 
      Caption         =   "KPCI-PIOxx Digital Channel 1"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   1080
      TabIndex        =   13
      Top             =   2880
      Width           =   2295
   End
   Begin VB.Label Label4 
      Caption         =   "Device Number"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3240
      TabIndex        =   12
      Top             =   600
      Width           =   1335
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   1
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim i As Integer
Dim DOValue As Byte  ' declare a byte
Dim InputRelaysPresent As Boolean
Dim DevNumber As Integer


Private Sub Check1_Click(Index As Integer)
' if an relay position is input, disable it from the output control frame
InputRelaysPresent = False
Select Case Index
Case 0:
If Check1(0).value = 1 Then
chkPortB(7).Enabled = False
chkPortB(7).value = 0
InputRelaysPresent = True
Else
chkPortB(7).Enabled = True
End If

Case 1:
If Check1(1).value = 1 Then
chkPortB(6).Enabled = False
chkPortB(6).value = 0
InputRelaysPresent = True
Else
chkPortB(6).Enabled = True
End If

Case 2:
If Check1(2).value = 1 Then
chkPortB(5).Enabled = False
chkPortB(5).value = 0
InputRelaysPresent = True
Else
chkPortB(5).Enabled = True
End If

Case 3:
If Check1(3).value = 1 Then
chkPortB(4).Enabled = False
chkPortB(4).value = 0
InputRelaysPresent = True
Else
chkPortB(4).Enabled = True
End If

End Select
End Sub

Private Sub cmdInit_Click()
' get the device number
DevNumber = CInt(Combo1.Text)
' open the driver and initialize the hardware

With SR
.Req_DLL_name = "kpcipio$" ' give Driver name to avoid Open DriverLINX dialog
' the $ on end means load only this driver.  If fails, do NOT give OpenDriverLINX Dialog
.Req_device = DevNumber
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With

' error check
If SR.Res_result = DL_NoErr Then
'
' ****************************************************************************
' assumes the board has digital channel 1 that can be configured for output
'

ConfigureChannelforOutputMode 1 ' config digital channels 1 for output
WriteDOSingleValue i, &H0       ' write a &H0 to the channel

' a logic 1 at the bit will put the relay into an OFF state
' a logic 0 at the bit will put the relay into an ON state

' use of the LDD control is not required
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "Using the SRA-01 with " & LDD.Dev_Model
cmdInit.Enabled = False
Frame3.Enabled = True
' turn on a polling timer.  Look in the timer event to see what happens next.
Timer1.Interval = 250
Timer1.Enabled = True
Else
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus

End Sub


Private Sub Form_Load()
cmdInit.ToolTipText = " Step 1:  Open the DriverLINX driver and Initialize" & _
                      " the KPCI hardware."
                      
'populate combo box with legal values for device numbers
Combo1.AddItem "0", 0
Combo1.AddItem "1", 1
Combo1.AddItem "2", 2
Combo1.AddItem "3", 3
Combo1.AddItem "4", 4
Combo1.AddItem "5", 5
Combo1.ListIndex = 0

End Sub

Private Sub Form_Terminate()
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub


Sub ConfigureChannelforOutputMode(ByVal chan As Integer)
With SR
.Req_subsystem = DL_DO  ' assign the channel the DL_DO subsystem
.Req_mode = DL_OTHER
.Req_op = DL_CONFIGURE
.Evt_Tim_type = DL_DIOSETUP
.Evt_Tim_dioChannel = chan
.Evt_Tim_dioMode = DL_DIO_BASIC
.Refresh
End With
End Sub

Private Sub Timer1_Timer()
' initialize our array variable
DOValue = 0
' read in values of the check box arrays to write to the ports
For i = 0 To 7
DOValue = DOValue + chkPortB(i) * 2 ^ i  '8 bits of channel 1
Next i
'
' a logic 0 at the bit will put the relay into an OFF state
' a logic 1 at the bit will put the relay into an ON state

WriteDOSingleValue 1, DOValue
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' read the inputs at Port C if we have input relays....
If InputRelaysPresent = True Then
lblDIValue = ReadDISingleValue(2) And &HF   ' read port C, but mask off upper nibble
' a logic 1 means the input relay is OFF
' a logic 0 means the input relay is ON
Else
lblDIValue = "no input relays"
End If
End Sub

Sub WriteDOSingleValue(chan As Integer, value As Byte)
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = chan         ' the channel to write to
.Res_Sta_ioValue = value       ' what value to write
.Refresh                       ' carry out the task
End With
End Sub

Function ReadDISingleValue(chan As Integer) As Byte
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_POLLED  ' no pacing clock involved
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_NULLEVENT  ' no timing for Polled mode
' Select Group
.Sel_buf_N = 0                 ' no buffers used
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' one channel
.Sel_chan_start = chan         ' the channel to write to
.Refresh                       ' carry out the task
End With
ReadDISingleValue = SR.Res_Sta_ioValue ' return the read value
End Function
